
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.0005f
float4x4	g_shadowerTransform;
float		g_light_farPlane;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};


struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float4 colour		: COLOR0;
	float4 specular		: COLOR1;
	
	float2 tex0			: TEXCOORD0;
	float3 tex1			: TEXCOORD1;
	float3 normal		: TEXCOORD2;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_lighting_low( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	output.normal = normalize(mul(input.normal, (float3x3)shader_transform_world));
		
	float3 vCamera = normalize(output.position-shader_camera_eyePosition);
	float3 vHalfway = normalize(-shader_light_direction - vCamera);
	
	output.specular = shader_material_specular.r * shader_light_specular.r * saturate(pow(dot( output.normal, vHalfway ), (1.0 / shader_material_eccentricity)*5));
	output.colour = input.colour * shader_geometry_colour * float4(shader_light_ambient.rgb + saturate(dot( output.normal, -shader_light_direction )) * shader_light_diffuse.rgb,shader_material_transparency + output.specular.r);

	output.position = mul(output.position, shader_transform_viewProj);

  	output.tex0 = input.tex0;
	output.tex1 = reflect( vCamera,output.normal );

	return output;
}

VS_OUTPUT_HIGH vs_lighting_low_base( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	output.normal = normalize(mul(input.normal, (float3x3)shader_transform_world));
		
	float3 vCamera = normalize(output.position-shader_camera_eyePosition);
	float3 vHalfway = normalize(-shader_light_direction - vCamera);
	
	output.specular = shader_material_specular.r * shader_light_specular.r * saturate(pow(dot( output.normal, vHalfway ), (1.0 / shader_material_eccentricity)*5));
	output.colour = shader_geometry_colour * float4(shader_light_ambient.rgb + saturate(dot( output.normal, -shader_light_direction )) * shader_light_diffuse.rgb,shader_material_transparency + output.specular.r);

	output.position = mul(output.position, shader_transform_viewProj);

  	output.tex0 = input.tex0;
	output.tex1 = reflect( vCamera,output.normal );

	return output;
}

////////////////////////////////////////////////////////////////////

sampler sampler_colour_0 = sampler_state 
{ 
	Texture = (shader_texture_0);  
	AddressU = Wrap; 
};

sampler sampler_colour_cube = sampler_state 
{ 
	Texture = (shader_texture_cubemap);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
};

////////////////////////////////////////////////////////////////////

float4 ps_lighting_low( VS_OUTPUT_HIGH input ) : COLOR0
{
	float4 textureColour = lerp( tex2D(sampler_colour_0, input.tex0), float4(texCUBE(sampler_colour_cube, input.tex1).rgb,1), shader_material_reflectivity);
	return float4((input.colour.rgb * textureColour.rgb + input.specular), input.colour.a * (textureColour.a + input.specular.r) );
}

////////////////////////////////////////////////////////////////////
// techniques

technique tech_lighting_low_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_low_base();	
	}
}


technique tech_lighting_low_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_low();	
		PixelShader = compile ps_2_0 ps_lighting_low();	
	}
}

////////////////////////////////////////////////////////////
